%
% Generate Figure 9-7 in Chapter 9 of the book:
%
% J. M. Mendel and Dongrui Wu, Perceptual Computing: Aiding People in
% Making Subjective Judgments, Wiley-IEEE Press, 2010.
%
% Dongrui WU (dongruiw@usc.edu), 7/30/2009
%

clc
close all
clear all
warning off all

K=21;
c=zeros(3,K);
r=zeros(3,K);

%% words FOUs from IA
%% word FOUs from IA
MFs=[0.0900    1.5000    3.0000    4.6200    1.7900    2.2800    2.2800    2.8100    0.4000
    0.0900    1.2500    2.5000    4.6200    1.6700    1.9200    1.9200    2.2100    0.3000
    3.5900    4.7500    5.5000    6.9100    4.8600    5.0300    5.0300    5.1400    0.2700
    5.9800    7.7500    8.6000    9.5200    8.0300    8.3600    8.3600    9.1700    0.5700
    7.3700    9.4100   10.0000   10.0000    8.7200    9.9100   10.0000   10.0000    1.0000
    5.3800    7.5000    8.7500    9.8100    7.7900    8.3000    8.3000    9.2100    0.5300];  % high

%% All 23 sub-criteria. The 4th column indicates whether this is a positive
subs=[43 36 38 1
    25 20 23 -1
    .72 .8 .75 1
    80 83 76 1
    67 70 63 1
    84 88 86 1
    15^2 12^2 18^2 1 % end Tactics
    521*35^2*135	381*34^2*105	445*35^2*120 -1
    1.2	1.5	1.3 -1
    0.6	0.6	0.7 1
    68	75	70 1
    5 4 4 2% end Technology
    6 2 2 -2
    5 4 4 2
    4 5 4 2
    4 4 4 2
    4 4 1 2 % end Maintenace
    800	755	785 -1
    7	7	5 1
    6 2 2 -2 % end Economy
    3 4 3 2
    1 5 4 2
    4 4 5 2]; % end Advancement
groups=[0 7 12 17 20 23];

fuzzyNumbers=[1 1 1 2 1 1 1 2 1
    1 2 2 3 1 2 2 3 1
    2 3 3 4 2 3 3 4 1
    3 4 4 5 3 4 4 5 1
    4 5 5 6 4 5 5 6 1
    5 6 6 7 5 6 6 7 1
    6 7 7 8 6 7 7 8 1
    7 8 8 9 7 8 8 9 1
    8 9 9 9 8 9 9 9 1];

Ws=[7 1 9 9 9 7 6 4 9 9 8 9 5 6 2 3 3 8 8 5 5 7 3  9 3 1 5 7];

for k=1:K
    unctns=(k-1)*[.01 .01 .01];
    for i=1:size(subs,1)
        if subs(i,end)==1
            for j=1:size(subs,2)-1
                temp2(i,2*j-1:2*j)=[subs(i,j)*(1-unctns(j)) min(max(subs(i,:)),subs(i,j)*(1+unctns(j)))];
            end
            temp2(i,:)=temp2(i,:)/max(temp2(i,:))*10; % map to a number in [0, 10]
        elseif subs(i,end)==-1
            for j=1:size(subs,2)-1
                temp2(i,2*j-1:2*j)=[1/max(min(subs(i,:)),subs(i,j)*(1+unctns(j))) 1/(subs(i,j)*(1-unctns(j)))];
            end
            temp2(i,:)=temp2(i,:)/max(temp2(i,:))*10; % map to a number in [0, 10]
        end

        for j=1:size(subs,2)-1
            if i==8
                subFSs(i,9*(j-1)+1:9*j) =[10*ones(1,8)*subs(i,j)^-1/max(subs(i,1:3).^-1) 1]; % no uncertainty
            else
                if abs(subs(i,4))==1
                    subFSs(i,9*(j-1)+1:9*j)=[temp2(i,2*j-1)*[1 1] temp2(i,2*j)*[1 1] temp2(i,2*j-1)*[1 1] temp2(i,2*j)*[1 1] 1];
                elseif subs(i,4)==2
                    subFSs(i,9*(j-1)+1:9*j)=MFs(subs(i,j),:);
                else %% complement
                    subFSs(i,9*(j-1)+1:9*j)=[10-MFs(subs(i,j),[4:-1:1 8:-1:5]) MFs(subs(i,j),9)];
                end
            end
        end
    end

    results2=zeros(5,27);
    for i=1:5
        for j=1:3
            results2(i,9*(j-1)+1:9*j)=LWA(subFSs(groups(i)+1:groups(i+1),9*(j-1)+1:9*j),fuzzyNumbers(Ws(groups(i)+1:groups(i+1)),:));
        end
    end
    for j=1:3
        temp=LWA(results2(1:5,9*(j-1)+[1:9]),fuzzyNumbers(Ws(end-4:end),:));
        [c(j,k),temp1,temp2]=centroidIT2(temp);
        r(j,k)=(temp2-temp1)/2;
    end
end

figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',12);
set(gcf,'DefaultlineLineWidth',1);
set(gcf,'DefaultaxesLineWidth',1);
subplot(2.7,2,1);
plot([0:1:K-1],c(1,:),'k-','linewidth',1.5);
hold on
plot([0:1:K-1],c(2,:),'k--','linewidth',1.5);
plot([0:1:K-1],c(3,:),'k:','linewidth',1.5);
legend('c_A','c_B','c_C','location','southeast');
set(gca,'XTick',[0:2:K-1]);
xlabel('v','FontAngle','italic'); ylabel('c','FontAngle','italic');
axis([0 K-1 0 10]);
saveas(gcf,'Fig9-7a.eps');

figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',12);
set(gcf,'DefaultlineLineWidth',1);
set(gcf,'DefaultaxesLineWidth',1);
subplot(2.7,2,1);
plot([0:1:K-1],r(1,:),'k-','linewidth',1.5);
hold on
plot([0:1:K-1],r(2,:),'k--','linewidth',1.5);
plot([0:1:K-1],r(3,:),'k:','linewidth',1.5);
legend('\delta_A','\delta_B','\delta_C','location','northwest');
set(gca,'XTick',[0:2:K-1]);
xlabel('v','FontAngle','italic'); ylabel('\delta','FontAngle','italic');
axis([0 K-1 0 1]);
saveas(gcf,'Fig9-7b.eps');

